<?php

abstract class Component {
    public readonly int $bytes;

    abstract public function write(int $byte, int $value) : void;
    abstract public function read(int $byte) : int;
}

abstract class Opcode {
    private Components $components;
    private Registers $registers;

    abstract public function __construct(Components &$components, Registers &$registers, int &$depth, Register &$programCounter);

    abstract public function execute(int $args) : void;
}