#include "trade.h"

double trade(struct bot seller, struct bot buyer)
{
	double price_end;
	price_end = (seller.price_proposed + buyer.price_proposed) / 2;
	if ((price_end > seller.price_cap) || (price_end < buyer.price_cap))
		return -1;
	return price_end;
}

void trade_bot_list(struct bot_item *seller, struct bot_item *buyer)
{
	struct bot_item *s, *b;
	double price, score;
	for (s = seller; s; s = s->next) {
		for (b = buyer; b; b = b->next) {
			price = trade(s->data, b->data);
			if (price == -1) {
				s->score += 250;
				b->score += 250;
				continue;
			}
			s->score += s->data.price_best - price;
			b->score += price - b->data.price_best;
			score = s->score;
			s->score += b->score / 4;
			b->score += score / 4;
		}
	}
}
