Unit IO;
Interface
	Uses
		Player, Enemies;

	Procedure IOWriteWorld(Player: PlayerType; Enemies: EnemiesType);
	Procedure IOParseInput(Var Player: PlayerType);
	Procedure IOLose();

Implementation
	Uses
		Crt;

	Procedure IOWriteEnemy(Enemy: EnemyType; Player: PlayerType);
	Begin
		GotoXY(Enemy.Position - Player.Score + 3, WhereY);
		Case Enemy.Id Of
			0:
				Write('#');
			1:
				Begin
					GotoXY(WhereX, WhereY - 1);
					Write('=');
					GotoXY(WhereX, WhereY + 1);
				End;
			2:
				Begin
					GotoXY(WhereX, WhereY + 1);
					Write('V');
					GotoXY(Wherex, WhereY - 1);
				End;
			3:
				Write('.');
			4:
				Write('_');
		End;
	End;

	Procedure IOWriteEnemies(Enemies: EnemiesType; Player: PlayerType);
	Var
		Tmp: EnemyPtrType;
	Begin
		Tmp := Enemies.First;
		While Tmp <> Nil Do
		Begin
			IOWriteEnemy(Tmp^, Player);
			Tmp := Tmp^.Next;
		End;
	End;

	Procedure IOWriteSurface();
	Var
		I: Byte;
	Begin
		For I := 1 To ScreenWidth Do
			Write('#');
	End;

	Procedure IOWritePlayer(Player: PlayerType);
	Begin
		If Player.IsDown Then
		Begin
			Write('-@');
			Exit;
		End;
		If Player.IsJump Then
		Begin
			Write(' ');
			GotoXY(WhereX - 1, WhereY - 1);
		End;
		Write('|');
		GotoXY(WhereX - 1, WhereY - 1);
		Write('@');
	End;

	Procedure IOWriteScore(Player: PlayerType);
	Begin
		GotoXY(1, 1);
		Write('Score: ', Player.Score);
	End;

	Procedure IOWriteWorld(Player: PlayerType; Enemies: EnemiesType);
	Begin
		Clrscr;
		GotoXY(3, Round(ScreenHeight / 2));
		IOWritePlayer(Player);
		IOWriteScore(Player);
		GotoXY(1, Round(ScreenHeight / 2) + 1);
		IOWriteSurface();
		GotoXY(1, Round(ScreenHeight / 2));
		IOWriteEnemies(Enemies, Player);
		GotoXY(ScreenWidth, ScreenHeight);
	End;

	Procedure IOGetKey(Var Code: Integer);
	Begin
		Code := Ord(ReadKey());
		If Code = 0 Then
			Code := -Ord(ReadKey());
	End;

	Procedure IOParseInput(Var Player: PlayerType);
	Var
		KeyCode: Integer;
	Begin
		If Not KeyPressed Then
			Exit;
		IOGetKey(KeyCode);
		Case KeyCode Of
			-72: { Up arrow key }
				PlayerJump(Player);
			-80: { Down arrow key }
				PlayerDown(Player);
			Ord('q'):
				Halt(0);
		End;
	End;

	Procedure IOLose();
	Var
		Emoji, X: Byte;
		Key: Integer;
	Begin
		Emoji := Random(6);
		X := Round(ScreenWidth / 2);
		GotoXY(X, Round(ScreenHeight / 2) - 5);
		Write('You lose');
		Case Emoji Of
			0:
				Write(':(');
			1:
				Write(';-D');
			2:
				Write('XD');
			3:
				Write('#_#');
			4:
				Write(' lol');
			5:
				Write('J_J');
		End;
		GotoXY(X, WhereY - 2);
		Write('r - Restart');
		GotoXY(X, WhereY - 1);
		Write('q - Quit');
		GotoXY(ScreenWidth, ScreenHeight);
		IOGetKey(Key);
		If Key = Ord('q') Then
			Halt(0);
	End;
End.
