Unit Enemies;
Interface
	Uses
		Player;
	Type
		EnemyPtrType = ^EnemyType;
		EnemyType = Record
			Position: Longword;
			Id: Byte;
			Next, Previous: EnemyPtrType;
		End;
		EnemiesType = Record
			Tick: Byte;
			First, Last: EnemyPtrType;
		End;

	Procedure EnemiesInit(Var Enemies: EnemiesType);
	Procedure EnemiesUpdate(Var Enemies: EnemiesType;
	       	Player: PlayerType);
	Procedure EnemiesMove(Var Enemies: EnemiesType; Count: Longint);

Implementation
	Uses
		Crt;
	Const
		SpawnEnemyTime = 20;
		Width = 80;

	Procedure EnemiesInit(Var Enemies: EnemiesType);
	Begin
		Enemies.First := Nil;
		Enemies.Last := Nil;
		Enemies.Tick := SpawnEnemyTime;
	End;
	
	Procedure EnemiesMove(Var Enemies: EnemiesType; Count: Longint);
	Var
		Tmp: EnemyPtrType;
	Begin
		Tmp := Enemies.First;
		While Tmp <> Nil Do
		Begin
			Tmp^.Position := Tmp^.Position - Count;
			Tmp := Tmp^.Next;
		End;
	End;

	Procedure EnemiesAddEnemy(Var Enemies: EnemiesType;
		Player: PlayerType);
	Var
		Tmp: EnemyPtrType;
	Begin
		New(Tmp);
		Tmp^.Position := Player.Score + Width - 4;
		Tmp^.Id := Random(5);
		Tmp^.Next := Enemies.First;
		If Tmp^.Next <> Nil Then
			Tmp^.Next^.Previous := Tmp;
		Enemies.First := Tmp;
		If Enemies.Last = Nil Then
			Enemies.Last := Enemies.First;
	End;

	Procedure EnemiesClearEnemy(Var Enemies: EnemiesType;
		Player: PlayerType);
	Begin
		If Enemies.Last = Nil Then
			Exit;
		If Enemies.Last^.Position + 3 > Player.Score Then
			Exit;
		If Enemies.Last^.Previous = Nil Then
		Begin
			Dispose(Enemies.Last);
			Enemies.Last := Nil;
		End;
		If Enemies.Last^.Previous <> Nil Then
		Begin
			Enemies.Last := Enemies.Last^.Previous;
			Dispose(Enemies.Last^.Next);
			Enemies.Last^.Next := Nil;
		End;
		EnemiesClearEnemy(Enemies, Player);
	End;

	Procedure EnemiesUpdate(Var Enemies: EnemiesType;
		Player: PlayerType);
	Begin
		EnemiesClearEnemy(Enemies, Player);
		If Enemies.Tick = SpawnEnemyTime Then
		Begin
			Enemies.Tick := 0;
			EnemiesAddEnemy(Enemies, Player);
		End;
		Enemies.Tick := Enemies.Tick + 1;
	End;
	
End.
