Program Dino;
Uses
	Player, IO, Enemies, Crt;

Procedure EndGameIfLose(Var Player: PlayerType;
	Var Enemies: EnemiesType; Var IsLose: Boolean);
Begin
	IsLose := False;
	If Enemies.Last = Nil Then
		Exit;
	If Enemies.Last^.Position <> Player.Score Then
		Exit;
	If (Enemies.Last^.Id = 0) And (Not Player.IsJump) Then
		IOLose()
	Else If (Enemies.Last^.Id = 1) And (Not Player.IsDown) Then
		IOLose()
	Else If (Enemies.Last^.Id = 2) And (Not Player.IsJump) Then
       		IOLose()
	Else If (Enemies.Last^.Id = 3) And (Not Player.IsJump) Then
	Begin
		EnemiesMove(Enemies, Round(Player.Score * 0.3));
		Player.Score := Round(Player.Score * 0.7);
		Exit;
	End
	Else If (Enemies.Last^.Id = 4) And (Not Player.IsJump) Then
		IOLose()
	Else
		Exit;
	IsLose := True;
End;

Function Max(Num1: Longint; Num2: Longint): Longint;
Begin
	Max := Num1;
	If Num2 > Max Then
		Max := Num2;
End;

Procedure GameLoop(Player: PlayerType; Enemies: EnemiesType);
Var
	IsLose: Boolean;
Begin
	IsLose := False;
	While True Do
	Begin
		EndGameIfLose(Player, Enemies, IsLose);
		PlayerUpdate(Player);
		EnemiesUpdate(Enemies, Player);
		IOParseInput(Player);
		IOWriteWorld(Player, Enemies);
		If IsLose Then
			Exit;
		Delay(Max(50, 250 - (Player.Score Div 5)));
	End;
End;

Procedure GameInit();
Var
	Player: PlayerType;
	Enemies: EnemiesType;
Begin
	Randomize();
	PlayerInit(Player);
	EnemiesInit(Enemies);
	GameLoop(Player, Enemies);
End;

Begin
	While True Do
		GameInit();
End.
